SELECT tsystem.function__drop_by_regex( 'abk_term', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.abk_term(
    IN  _ab_ix integer,
    IN  _start_date date,
    IN  _forward boolean = true,
    IN  _pack_abk boolean = false,
    IN _dlz_terminiation boolean = false
    )
    RETURNS date
    AS $$
    DECLARE
      _r record;
      _term_frame_begin date;
      _term_frame_end date;
      _work_date date;
    BEGIN

        PERFORM tplanterm.abk_austerm(get_all_child_abk) FROM tplanterm.get_all_child_abk(_ab_ix);

        SELECT min(ti_date_start) AS start, max(ti_date_end) AS finish
          INTO _r
          FROM scheduling.abk__termination_group_execute(
                    _ab_ix
                  , _start_date
                  , _write_to_disk => true
                  , _forward__backward => ifthen( _forward, ifthen( _pack_abk, 'forward-pack', 'forward' ), 'backward' )
                  , _dlz_terminiation => _dlz_terminiation
                );

        IF _forward THEN
           _work_date := _r.finish;
        ELSE
           _work_date := _r.start;
           IF _work_date IS null THEN
             RAISE EXCEPTION 'TermInPastError';
           END IF;
        END IF;

        RETURN _work_date;

    END $$ LANGUAGE plpgsql;